/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class Processor
extends AbstractProcessor {
    protected Types types;
    protected Elements elements;
    protected Filer filer;
    protected Messager messager;
    protected PackageElement base;
    private Set<String> supported = null;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    public abstract Class<?>[] getTypes();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        if (this.supported == null) {
            HashSet<String> s = new HashSet<String>();
            for (Class<?> clazz : this.getTypes()) {
                s.add(clazz.getCanonicalName());
            }
            this.supported = s;
        }
        return this.supported;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    protected TypeMirror forClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.types.getArrayType(this.forClass(clazz.getComponentType()));
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return this.types.getNoType(TypeKind.VOID);
            }
            if (clazz == Boolean.TYPE) {
                return this.types.getPrimitiveType(TypeKind.BOOLEAN);
            }
            if (clazz == Byte.TYPE) {
                return this.types.getPrimitiveType(TypeKind.BYTE);
            }
            if (clazz == Character.TYPE) {
                return this.types.getPrimitiveType(TypeKind.CHAR);
            }
            if (clazz == Short.TYPE) {
                return this.types.getPrimitiveType(TypeKind.SHORT);
            }
            if (clazz == Integer.TYPE) {
                return this.types.getPrimitiveType(TypeKind.INT);
            }
            if (clazz == Long.TYPE) {
                return this.types.getPrimitiveType(TypeKind.LONG);
            }
            if (clazz == Float.TYPE) {
                return this.types.getPrimitiveType(TypeKind.FLOAT);
            }
            if (clazz == Double.TYPE) {
                return this.types.getPrimitiveType(TypeKind.DOUBLE);
            }
            return null;
        }
        return this.elements.getTypeElement(clazz.getCanonicalName()).asType();
    }

    protected boolean isSuppressed(Element element, String warnings) {
        SuppressWarnings sw = element.getAnnotation(SuppressWarnings.class);
        if (sw != null) {
            return Arrays.asList(sw.value()).contains(warnings);
        }
        return false;
    }

    protected <T extends Element> Optional<T> contained(Element element, Class<T> clazz) {
        return this.contained(element, clazz, elem -> true);
    }

    protected <T extends Element> Optional<T> contained(Element element, Class<T> clazz, Predicate<T> filter) {
        return element.getEnclosedElements().stream().filter(e -> clazz.isAssignableFrom(e.getClass())).filter(e -> filter.test(e)).findFirst();
    }

    protected boolean sameErasure(TypeMirror type1, TypeMirror type2) {
        return this.types.isSameType(this.types.erasure(type1), this.types.erasure(type2));
    }

    protected TypeMirror classType(Supplier<Class<?>> accessor) {
        try {
            return this.forClass(accessor.get());
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    protected List<? extends TypeMirror> classTypes(Supplier<List<Class<?>>> accessor) {
        try {
            return accessor.get().stream().map(this::forClass).collect(Collectors.toList());
        }
        catch (MirroredTypesException e) {
            return e.getTypeMirrors();
        }
    }

    protected TypeMirror boxed(TypeMirror type) {
        if (type.getKind() == TypeKind.VOID) {
            return this.forClass(Void.class);
        }
        if (type.getKind() == TypeKind.BOOLEAN) {
            return this.forClass(Boolean.class);
        }
        if (type.getKind() == TypeKind.BYTE) {
            return this.forClass(Byte.class);
        }
        if (type.getKind() == TypeKind.CHAR) {
            return this.forClass(Character.class);
        }
        if (type.getKind() == TypeKind.SHORT) {
            return this.forClass(Short.class);
        }
        if (type.getKind() == TypeKind.INT) {
            return this.forClass(Integer.class);
        }
        if (type.getKind() == TypeKind.LONG) {
            return this.forClass(Long.class);
        }
        if (type.getKind() == TypeKind.FLOAT) {
            return this.forClass(Float.class);
        }
        if (type.getKind() == TypeKind.DOUBLE) {
            return this.forClass(Double.class);
        }
        return type;
    }

    protected TypeMirror unboxed(TypeMirror type) {
        if (this.sameErasure(type, this.forClass(Void.class))) {
            return this.forClass(Void.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Boolean.class))) {
            return this.forClass(Boolean.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Byte.class))) {
            return this.forClass(Byte.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Character.class))) {
            return this.forClass(Character.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Short.class))) {
            return this.forClass(Short.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Integer.class))) {
            return this.forClass(Integer.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Long.class))) {
            return this.forClass(Long.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Float.class))) {
            return this.forClass(Float.TYPE);
        }
        if (this.sameErasure(type, this.forClass(Double.class))) {
            return this.forClass(Double.TYPE);
        }
        return type;
    }
}

